console.log('Background script loaded');

// Listen for messages from content script
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
    console.log('Received message:', request);
    
    if (request.action === "getYouTubeCookies") {
        console.log('Getting YouTube cookies...');
        
        // Get all YouTube cookies
        chrome.cookies.getAll({
            domain: "youtube.com"
        }).then(cookies => {
            console.log('Found cookies:', cookies.length);
            
            // Start with the Netscape cookies file header
            let cookiesText = `# Netscape HTTP Cookie File
# https://curl.haxx.se/rfc/cookie_spec.html
# This is a generated file!  Do not edit.

`;
            
            // Convert cookies to Netscape format (cookies.txt)
            cookiesText += cookies.map(cookie => {
                const domain = cookie.domain.startsWith('.') ? cookie.domain : '.' + cookie.domain;
                const secure = cookie.secure ? "TRUE" : "FALSE";
                const httpOnly = cookie.httpOnly ? "TRUE" : "FALSE";
                const path = cookie.path || '/';
                // Set expiration to 1 year from now if not provided
                const expiration = Math.floor((cookie.expirationDate || (Date.now()/1000 + 31536000)));
                
                // Correct format is:
                // domain    domain_start_dot    path    secure    expiry    name    value
                return `${domain}\tTRUE\t${path}\t${secure}\t${expiration}\t${cookie.name}\t${cookie.value}`;
            }).join('\n');
            
            // Get cookies from .youtube.com domain as well
            chrome.cookies.getAll({
                domain: ".youtube.com"
            }).then(moreCookies => {
                console.log('Found additional cookies:', moreCookies.length);
                
                // Add additional cookies
                cookiesText += '\n' + moreCookies.map(cookie => {
                    const secure = cookie.secure ? "TRUE" : "FALSE";
                    const httpOnly = cookie.httpOnly ? "TRUE" : "FALSE";
                    const path = cookie.path || '/';
                    const expiration = Math.floor((cookie.expirationDate || (Date.now()/1000 + 31536000)));
                    
                    return `.youtube.com\tTRUE\t${path}\t${secure}\t${expiration}\t${cookie.name}\t${cookie.value}`;
                }).join('\n');
                
                console.log('Sending cookies back to content script');
                sendResponse({ success: true, cookiesText });
            }).catch(error => {
                console.error('Error getting additional cookies:', error);
                sendResponse({ success: false, error: error.message });
            });
        }).catch(error => {
            console.error('Error getting cookies:', error);
            sendResponse({ success: false, error: error.message });
        });
        
        // Return true to indicate we will send a response asynchronously
        return true;
    }
});